﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;


public class CPatientConsultXfer : CData
{
    /// <summary>
    /// US:6007 constructor
    /// </summary>
    /// <param name="data"></param>
    public CPatientConsultXfer(CData data)
        : base(data)
    {
        //constructors are not inherited in c#!
    }

    /// <summary>
    /// US:6007 saves a patient consult to the central database
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="pdi"></param>
    /// <returns></returns>
    public CStatus SavePatientConsult(long lXferSystemID,
                                      CPatientConsultItemXfer pdi)
    {
        //check the patient id
        if (pdi == null || String.IsNullOrEmpty(pdi.ConsultID))
        {
            return new CStatus(false, k_STATUS_CODE.Failed, "Could not save consult, invalid data!"); ;
        }

        //check the data connection
        CStatus status = DBConnValid();
        if (!status.Status)
        {
            return status;
        }

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(SessionID, ClientIP, UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nRegionID", this.RegionID);
        pList.AddInputParameter("pi_nSiteID", this.SiteID);
        pList.AddInputParameter("pi_vDFN", pdi.DFN);

        pList.AddInputParameter("pi_vConsultID", pdi.ConsultID);
        pList.AddInputParameter("pi_vConsultTimeStamp", pdi.ConsultTimeStamp);
        pList.AddInputParameter("pi_vConsultStatus", pdi.ConsultStatus);
        pList.AddInputParameter("pi_vConsultTitle", pdi.ConsultTitle);

        //adjust text to 4000 chars max
        if (pdi.ConsultText.Length > 4000)
        {
            pdi.ConsultText = pdi.ConsultText.Substring(0, 3997) + "...";
        }
        
        pList.AddInputParameter("pi_vConsultText", pdi.ConsultText);

        //execute the transfer SP
        CStatus statusXfer = DBConn.ExecuteOracleSP("PCK_XFER.XferPatientConsult", pList);
        if (statusXfer.Status)
        {
            //good to go
        }

        return statusXfer;
    }
    
}
